<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Logic\Action\Storefront\Auth\Whoami\Assembler;

use XCart\Bundle\DoctrineBridgeBundle\Assembler\GetOne\Response\ResponseAssemblerInterface;
use XCart\Bundle\DoctrineBridgeBundle\Entity\EntityInterface;
use XCart\Bundle\LogicBundle\DTO\Response\PayloadOwnerResponseInterface;
use XCart\Factory\Logic\Action\Storefront\Principal\GetOne\DTO\ResponseInterface;
use XCart\Logic\Action\Storefront\Principal\GetOne\DTO\Response;
use XCart\Transformer\XLite\Model\Profile\Logic\Entity\Storefront\PrincipalInterface as TransformerInterface;
use XLite\Model\Profile;

class ResponseAssembler implements ResponseAssemblerInterface
{
    public function __construct(
        private ResponseInterface $responseFactory,
        private TransformerInterface $transformer,
    ) {
    }

    /**
     * @param ?Profile $entity
     *
     * @return Response
     */
    public function assemble(?EntityInterface $entity): PayloadOwnerResponseInterface
    {
        return $this->responseFactory->create()
            ->setPayload($this->transformer->transform($entity));
    }
}
