<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Logic\Action\Storefront\Address\UpdateOne\Enricher\Transparent;

use XCart\Bundle\CommonBundle\Enricher\Transparent\TransparentEnricherInterface;
use XCart\Operation\Service\Storefront\Address\SetAddressFieldsInterface;

class WalkingTransparentEnricherDecorator implements TransparentEnricherInterface
{
    public function __construct(
        private TransparentEnricherInterface $inner,
        private SetAddressFieldsInterface $setAddressFields,
    ) {
    }

    /**
     * @param \XLite\Model\Address                $initial
     * @param \XCart\Logic\Entity\Storefront\Address $input
     *
     * @return \XLite\Model\Address
     */
    public function enrich(object $initial, object $input): object
    {
        if ($input->getIsShipping() !== null) {
            $initial->setIsShipping(
                $input->getIsShipping()
            );
        }

        if ($input->getIsBilling() !== null) {
            $initial->setIsBilling(
                $input->getIsBilling()
            );
        }

        ($this->setAddressFields)($input, $initial);

        return $initial;
    }
}
