<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Logic\Action\Storefront\Address\UpdateOne;

use XCart\Bundle\DoctrineBridgeBundle\Repository\ReadRepositoryInterface;
use XCart\Bundle\LogicBundle\Action\ActionInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;
use XCart\Logic\Entity\Storefront\Address;
use XLite\Model\Address as AddressModel;
use XLite\Model\Repo\Profile as ProfileRepo;

class ActionDecorator implements ActionInterface
{
    /**
     * @param ProfileRepo $profileRepository
     */
    public function __construct(
        private ActionInterface $inner,
        private ReadRepositoryInterface $profileRepository,
    ) {
    }

    public function run(RequestInterface $request): ResponseInterface
    {
        /** @var Address $payload */
        $payload = $request->getPayload();

        $this->changeOtherAddresses(
            $payload->getId(),
            $payload->getIsBilling(),
            $payload->getIsShipping(),
            $payload->getProfileId()
        );

        return $this->inner->run($request);
    }

    private function changeOtherAddresses(
        int $currentAddressId,
        bool $isCurrentAddressBilling,
        bool $isCurrentAddressShipping,
        ?int $profileId
    ): void {
        if ($isCurrentAddressShipping || $isCurrentAddressBilling) {
            $profile = $this->profileRepository->find($profileId);

            if ($profile) {
                /** @var AddressModel $address */
                foreach ($profile->getAddresses() as $address) {
                    if ($currentAddressId === $address->getAddressId()) {
                        continue;
                    }

                    if ($isCurrentAddressBilling) {
                        $address->setIsBilling(false);
                    }

                    if ($isCurrentAddressShipping) {
                        $address->setIsShipping(false);
                    }
                }
            }
        }
    }
}
