<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Logic\Action\Storefront\Address\CreateOne\Action;

use Symfony\Component\HttpFoundation\Response as HTTPResponse;
use XCart\Bundle\LogicBundle\Action\ActionInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Response\DefaultFailedResponse;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;

class CheckAuthDecorator implements ActionInterface
{
    public function __construct(
        private ActionInterface $inner,
    ) {
    }

    public function run(RequestInterface $request): ResponseInterface
    {
        if (!$request->getPayload()->getProfileId()) {
            return (new DefaultFailedResponse())
                ->setType('/errors/validation')
                ->setTitle('Profile not found')
                ->setStatus(HTTPResponse::HTTP_UNPROCESSABLE_ENTITY);
        }

        return $this->inner->run($request);
    }
}
