<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\LifetimeHook\Upgrade;

use XCart\Doctrine\FixtureLoader;
use XLite\Core\Database;
use XLite\Model\Config;

final class UpgradeTo551build6
{
    public function __construct(
        private FixtureLoader $fixtureLoader
    ) {
    }

    /**
     * @throws \Exception
     */
    public function onUpgrade(): void
    {
        $this->fixtureLoader->loadYaml(LC_DIR_ROOT . 'upgrade/5.5/1.6/upgrade.yaml');

        $this->updateLocationAddresses();

        Database::getEM()->flush();
    }

    private function updateLocationAddresses(): void
    {
        $configRepo = Database::getRepo(Config::class);

        foreach (['location_address', 'origin_address', 'anonymous_address'] as $oldName) {
            $newName         = "{$oldName}1";
            $configAddresses = $configRepo?->findBy(
                ['name' => [$oldName, $newName], 'category' => 'Company'],
                ['name' => 'ASC'] //  location_address, location_address1, location_address2
            ) ?: [];

            /** @var Config[] $configAddresses */
            // don't mess with MultiVendor configs
            $configAddresses = array_filter($configAddresses, static fn($option) => (!property_exists($option, 'vendor') || !$option->getVendor()));

            $oldLocationAddress = $configAddresses[0] ?? null; // the first is probably old option

            if ($oldLocationAddress?->getName() === $oldName) {
                unset($configAddresses[0]);

                if (!$configAddresses) {
                    $oldLocationAddress->setName($newName); //  We should not be here, but now you are new
                } else {
                    $oldValue = $oldLocationAddress->getValue();

                    foreach ($configAddresses as $newConfig) {
                        if (
                            (
                                !$newConfig->getValue()
                                || stripos($newConfig->getValue(), 'Your company address') !== false
                            )
                            && $oldValue
                        ) {
                            // The value update is possible as the new value is still empty/default
                            $newConfig->setValue($oldValue);
                        }
                        $configRepo->delete($oldLocationAddress, false); // don't leave old-version DB options
                        break;
                    }
                }
            }
        }
    }
}
