<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\LifetimeHook\Upgrade;

use XLite\Core\Database;

final class UpgradeTo551build4
{
    protected array $config;

    /**
     * @param array $config
     */
    public function setConfig(array $config): void
    {
        $this->config = $config;
    }

    public function onUpgrade(): void
    {
        $this->removeDuplicatePaymentMethodTranslates();
    }

    private function removeDuplicatePaymentMethodTranslates(): void
    {
        $tablePrefix = '';
        foreach ($this->config as $data) {
            if ($data['class'] === '*') {
                $tablePrefix = $data['prefix'];
                break;
            }
        }

        if ($tablePrefix !== '') {
            $tablePrefix .= '_';
        }

        $dbal = Database::getEM()->getConnection();
        $tableName = $tablePrefix . 'payment_method_translations';

        $translationsIds = $dbal->fetchAllAssociative(
            "SELECT 
                {$tableName}.`label_id`
            FROM
                {$tableName}
            LEFT OUTER JOIN 
                (
                    SELECT MIN(`label_id`) AS `label_id`, `code`
                    FROM {$tableName}
                    GROUP BY `id`, `code`
                ) AS `tmp` 
            ON 
                {$tableName}.`label_id` = `tmp`.`label_id`  
            WHERE
                `tmp`.`label_id` IS NULL"
        );

        foreach ($translationsIds as $addressValueItem) {
            $dbal->delete($tableName, ['label_id' => $addressValueItem['label_id']]);
        }
    }
}
