<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\LifetimeHook\Upgrade;

use XCart\Doctrine\FixtureLoader;
use XLite\Core\Database;
use XLite\Model\Config;

final class UpgradeTo551build3
{
    public function __construct(
        private FixtureLoader $fixtureLoader
    ) {
    }

    public function onUpgrade(): void
    {
        $this->updateConfigOptions();
        $this->deleteConfigOptions();
        Database::getEM()->flush();
    }

    private function updateConfigOptions(): void
    {
        $this->fixtureLoader->loadYaml(LC_DIR_ROOT . 'upgrade/5.5/1.3/upgrade.yaml');
    }

    private function deleteConfigOptions(): void
    {
        /** @var \XLite\Model\Repo\Config $configRepo */
        $configRepo = Database::getRepo(Config::class);
        /** @var Config $element */
        $element = $configRepo->findOneBy(['name' => 'customer_presentation', 'category' => 'General']);
        if ($element) {
            $configRepo->delete($element, false);
        }
    }
}
