<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\LifetimeHook\Upgrade;

use XLite\Core\Database;
use XLite\Model\Config;

final class UpgradeTo551build14
{
    /**
     * @throws \Exception
     */
    public function onUpgrade(): void
    {
        $configRepo = Database::getRepo(Config::class);

        if ($configRepo) {
            $configPerformance = $configRepo->findBy(['category' => 'Performance']);

            /** @var Config $config */
            foreach ($configPerformance as $config) {
                if ($config->getName() === 'aggregate_css') {
                    $config->setOptionName('Aggregate CSS files');
                    continue;
                }

                if ($config->getName() === 'aggregate_js') {
                    $config->setOptionName('Aggregate JS files');
                    continue;
                }

                if ($config->getName() === 'use_view_cache') {
                    $config->setOptionName('Use widget cache');
                }
            }

            Database::getEM()->flush();
        }
    }
}
