<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\LifetimeHook\Upgrade;

use XCart\Doctrine\FixtureLoader;
use XLite\Core\Config;
use XLite\Core\Database;
use XLite\Model\Payment\Method as PaymentMethod;
use XLite\Model\Payment\MethodSetting;

final class UpgradeTo551build1
{
    public function __construct(
        private FixtureLoader $fixtureLoader
    ) {
    }

    public function onUpgrade(): void
    {
        $this->fixtureLoader->loadYaml(LC_DIR_ROOT . 'upgrade/5.5/1.1/upgrade.yaml');

        $this->moveSettingToEcheck();
    }

    private function moveSettingToEcheck(): void
    {
        $paymentMethod = Database::getRepo(PaymentMethod::class)->findOneBy(['service_name' => 'Echeck']);

        // 1. add new payment setting
        if ($paymentMethod) {
            $settingDisplayCheckNumber = Database::getRepo(MethodSetting::class)->findOneBy([
                'payment_method' => $paymentMethod,
                'name'           => 'display_check_number',
            ]);
            if (!$settingDisplayCheckNumber) {
                $settingDisplayCheckNumber = new MethodSetting();
                $settingDisplayCheckNumber->setName('display_check_number');
                $settingDisplayCheckNumber->setPaymentMethod($paymentMethod);
                $value = Config::getInstance()->General->display_check_number;
                $settingDisplayCheckNumber->setValue($value);
                Database::getEM()->persist($settingDisplayCheckNumber);
            }
        }

        // 2. remove obsolete config
        $repo            = Database::getRepo('XLite\Model\Config');
        $optionsToRemove = [
            'display_check_number' => 'General',
        ];

        foreach ($optionsToRemove as $optionName => $category) {
            $element = $repo->findOneBy(['name' => $optionName, 'category' => $category]);

            if ($element) {
                /** @var \XLite\Model\Config $element */
                $repo->delete($element, false);
            }
        }

        Database::getEM()->flush();
    }
}
