<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\EventListener\Payment;

use XCart\Event\Payment\PaymentActionEvent;
use XCart\Payment\RequestProcessor;

final class Offline
{
    public function onPaymentInitAction(PaymentActionEvent $event): void
    {
        $event->setOutputCode(RequestProcessor::OUTPUT_CODE_SILENT);
    }

    public function onPaymentPayAction(PaymentActionEvent $event): void
    {
        $event->setOutputCode(RequestProcessor::OUTPUT_CODE_PENDING);
    }
}
