<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\EventListener;

use Symfony\Component\HttpKernel\Event\ControllerEvent;
use XCart\Controller\Admin\IAdminZone;
use XCart\Controller\XCartController;

final class KernelControllerInitListener
{
    public function onKernelController(ControllerEvent $event): void
    {
        $controller = $event->getController();
        $action = '';

        if (is_array($controller)) {
            [$controller, $action] = $controller;
        }

        $xc = \XLite::getInstance();
        $xc->run(
            $controller instanceof IAdminZone
            || (
                $controller instanceof XCartController
                && $action === 'admin'
            )
        );
    }
}
