<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\EventListener;

use Doctrine\ORM\EntityManagerInterface;
use XCart\Event\Service\FixturesPostLoadEvent;
use XLite\Core\QuickData as QuickDataCore;
use XLite\Model\Category;

final class FixturesLoadedListener
{
    public function __construct(
        private EntityManagerInterface $entityManager
    ) {
    }

    public function handlePostLoad(FixturesPostLoadEvent $event): void
    {
        \XLite\Core\Database::getRepo(Category::class)?->correctCategoriesStructure();

        if ($event->getType() === 'install') {
            $this->quickDataRecalculate();
        }
    }

    private function quickDataRecalculate(): void
    {
        $quickData = QuickDataCore::getInstance();
        $batchSize = QuickDataCore::CHUNK_LENGTH;

        do {
            $products = $this->entityManager
                ->createQuery('SELECT p from XLite\Model\Product p WHERE p.needProcess = 1 order by p.product_id ASC')
                ->setMaxResults($batchSize)
                ->getResult();

            foreach ($products as $product) {
                $quickData->updateProductDataInternal($product);
            }

            $this->entityManager->flush();
        } while (count($products) > 0);
    }
}
