<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Event\Service;

use Symfony\Contracts\EventDispatcher\Event;
use XCart\Doctrine\CallbackManager\DeferredCallbackDto;

final class DeferrerCallbackRunEvent extends Event
{
    public const NAME = 'deferrer.callback.run';

    public function __construct(
        private array $deferredCallbackData
    ) {
    }

    /**
     * @return DeferredCallbackDto[]|null
     */
    public function getCallbackDto(string $deferredType): ?array
    {
        $result = $this->deferredCallbackData[$deferredType] ?? null;
        unset($this->deferredCallbackData[$deferredType]);

        return $result;
    }
}
