<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\EntityCallback;

use Doctrine\Persistence\Event\LifecycleEventArgs;
use Exception;
use XLite\Model\ViewList;

final class ViewListCallback
{
    public function prePersist(ViewList $viewList, LifecycleEventArgs $args): void
    {
        if (ViewList::getVersionKey() && !$viewList->getVersion()) {
            $viewList->setVersion(ViewList::getVersionKey());
        }
    }

    /**
     * @throws Exception
     */
    public function preRemove(ViewList $viewList, LifecycleEventArgs $args): void
    {
        if ($parent = $viewList->getParent()) {
            $parent->removeVariant($viewList);
        }

        foreach ($viewList->getVariants()->getIterator() as $child) {
            $child->deleteParent();
        }
    }
}
