<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\EntityCallback;

use Doctrine\Persistence\Event\LifecycleEventArgs;
use XLite\Model\Payment\Transaction;

final class TransactionCallback
{
    public function prePersist(Transaction $transaction, LifecycleEventArgs $args): void
    {
        if (!$transaction->getPublicTxnId()) {
            $transaction->setPublicTxnId(
                $transaction->generateTransactionId()
            );
        }

        if (!$transaction->getDate()) {
            $transaction->setDate(\XLite\Core\Converter::time());
        }

        if (!$transaction->getPublicId()) {
            if ($transaction->getPaymentMethod()) {
                $transaction->renewTransactionId();
            } else {
                $transaction->setPublicId($transaction->getPublicTxnId());
            }
        }
    }
}
