<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\EntityCallback;

use Doctrine\Persistence\Event\LifecycleEventArgs;
use XLite\Model\Base\Storage;

final class StorageCallback
{
    public function preRemove(Storage $storage, LifecycleEventArgs $args): void
    {
        if (!$storage->isURL()) {
            $storage->removeFile();
        }
    }

    public function prePersist(Storage $storage, LifecycleEventArgs $args): void
    {
        $this->prepareBeforeSave($storage);
    }

    public function preUpdate(Storage $storage, LifecycleEventArgs $args): void
    {
        $this->prepareBeforeSave($storage);
    }

    private function prepareBeforeSave(Storage $storage): void
    {
        if (!$storage->getDate()) {
            $storage->setDate(\XLite\Core\Converter::time());
        }
    }
}
