<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\EntityCallback;

use Doctrine\Persistence\Event\LifecycleEventArgs;
use XLite\Model\State;
use XLite\Model\ZoneElement;

final class StateCallback
{
    public function preRemove(State $state, LifecycleEventArgs $args): void
    {
        $entityManager = $args->getObjectManager();
        $elements = $entityManager->getRepository(ZoneElement::class)->findBy(
            [
                'element_type'  => ZoneElement::ZONE_ELEMENT_STATE,
                'element_value' => $state->getCountry()->getCode() . '_' . $state->getCode(),
            ]
        );

        foreach ($elements as $element) {
            $entityManager->remove($element);
        }
    }
}
