<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\EntityCallback;

use Doctrine\Persistence\Event\LifecycleEventArgs;
use XLite\Core\Auth;
use XLite\Core\Session;
use XLite\Model\Profile;

final class ProfileCallback
{
    public function prePersist(Profile $profile, LifecycleEventArgs $args): void
    {
        $session = Session::getInstance();
        $auth    = Auth::getInstance();

        // Assign a profile creation date/time
        if (!$profile->getAdded()) {
            $profile->setAdded(\XLite\Core\Converter::time());
        }

        if (!$profile->getLanguage(true) && !$profile->isPersistent()) {
            $profile->setLanguage($session->getLanguage()->getCode());
        }

        // Assign referer value
        if (empty($profile->getReferer())) {
            if ($auth->isAdmin()) {
                $currentlyLoggedInProfile = $auth->getProfile();
                $profile->setReferer(sprintf('Created by administrator (%s)', $currentlyLoggedInProfile?->getLogin()));
            } elseif (isset($_COOKIE[Session::LC_REFERER_COOKIE_NAME])) {
                $profile->setReferer($_COOKIE[Session::LC_REFERER_COOKIE_NAME]);
            }
        }

        $profile->updateSearchFakeField();

        // Assign status 'Enabled' if not defined
        if (empty($profile->getStatus())) {
            $profile->enable();
        }
    }

    public function preUpdate(Profile $profile, LifecycleEventArgs $args): void
    {
        if (
            $profile->getPendingMembershipId()
            && ($profile->getPendingMembershipId() === $profile->getMembershipId())
        ) {
            $profile->setPendingMembership(null);
        }

        $profile->updateSearchFakeField();
    }
}
