<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\EntityCallback;

use Doctrine\Persistence\Event\LifecycleEventArgs;
use XLite\Core\Database;
use XLite\Model\Payment\Method;
use XLite\Model\Payment\MethodTranslation;

final class PaymentMethodTranslationCallback
{
    private function clearPaymentMethodCacheByServiceName(string $serviceName): void
    {
        Database::getRepo(Method::class)?->deleteCacheByNameAndParams(
            'payment_method',
            ['service_name' => $serviceName]
        );
    }

    public function preUpdate(MethodTranslation $methodTranslation, LifecycleEventArgs $args): void
    {
        /** @var Method $method */
        $method = $methodTranslation->getOwner();

        $this->clearPaymentMethodCacheByServiceName($method->getServiceName());
    }
}
