<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\EntityCallback;

use Doctrine\Persistence\Event\LifecycleEventArgs;
use XLite\Core\Database;
use XLite\Model\Payment\Method;
use XLite\Model\Payment\MethodSetting;

final class PaymentMethodSettingCallback
{
    private function clearPaymentMethodCacheByServiceName(string $serviceName): void
    {
        Database::getRepo(Method::class)?->deleteCacheByNameAndParams(
            'payment_method',
            ['service_name' => $serviceName]
        );
    }

    public function preUpdate(MethodSetting $methodSetting, LifecycleEventArgs $args): void
    {
        $this->clearPaymentMethodCacheByServiceName($methodSetting->getPaymentMethod()->getServiceName());
    }
}
