<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\EntityCallback;

use Doctrine\Persistence\Event\LifecycleEventArgs;
use XLite\Core\Database;
use XLite\Model\Payment\Method;

final class PaymentMethodCallback
{
    private function clearPaymentMethodCacheByServiceName(string $serviceName): void
    {
        Database::getRepo(Method::class)?->deleteCacheByNameAndParams(
            'payment_method',
            ['service_name' => $serviceName]
        );
    }

    public function preUpdate(Method $method, LifecycleEventArgs $args): void
    {
        $this->clearPaymentMethodCacheByServiceName($method->getServiceName());
    }

    public function preRemove(Method $method, LifecycleEventArgs $args): void
    {
        $this->clearPaymentMethodCacheByServiceName($method->getServiceName());
    }
}
