<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\EntityCallback;

use Doctrine\Persistence\Event\LifecycleEventArgs;
use XLite\Model\OrderHistoryEvents;

final class OrderHistoryEventsCallback
{
    public function prePersist(OrderHistoryEvents $orderHistoryEvents, LifecycleEventArgs $args): void
    {
        $this->prepareBeforeSave($orderHistoryEvents);
    }

    public function preUpdate(OrderHistoryEvents $orderHistoryEvents, LifecycleEventArgs $args): void
    {
        $this->prepareBeforeSave($orderHistoryEvents);
    }

    private function prepareBeforeSave(OrderHistoryEvents $orderHistoryEvents): void
    {
        if (!is_numeric($orderHistoryEvents->getDate())) {
            $orderHistoryEvents->setDate(\XLite\Core\Converter::time());
        }
    }
}
