<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\EntityCallback;

use Doctrine\Persistence\Event\LifecycleEventArgs;
use Ramsey\Uuid\Uuid;
use XLite\Model\Order;

final class OrderCallback
{
    public function prePersist(Order $order, LifecycleEventArgs $args): void
    {
        $this->prepareBeforeSave($order);
    }

    public function preUpdate(Order $order, LifecycleEventArgs $args): void
    {
        $this->prepareBeforeSave($order);
    }

    private function prepareBeforeSave(Order $order): void
    {
        $time = \XLite\Core\Converter::time();
        if (!is_numeric($order->getDate()) || !is_int($order->getDate())) {
            $order->setDate($time);
        }

        $order->setLastRenewDate($time);
        $order->checkStatuses();

        if (!$order->getPublicId()) {
            $order->setPublicId(Uuid::uuid4());
        }
    }
}
