<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\EntityCallback;

use Doctrine\ORM\EntityManagerInterface;
use Doctrine\Persistence\Event\LifecycleEventArgs;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;
use XCart\Doctrine\CallbackManager\CallbackManager;
use XCart\Event\Service\DeferrerCallbackRunEvent;
use XLite\Core\QuickData;
use XLite\Model\Membership;

class MembershipCallback
{
    private QuickData $quickData;

    public function __construct(
        private CallbackManager $callbackManager,
        private EntityManagerInterface $entityManager
    ) {
        $this->quickData = \XLite\Core\QuickData::getInstance();
    }

    public function postPersist(Membership $membership, LifecycleEventArgs $args): void
    {
        $context = $this->callbackManager->getContextValue();
        if (!in_array($context, ['import', 'load-fixtures'], true) && $membership->getProducts()) {
            $this->callbackManager->addDeferredCallback(
                'quickDataMembershipRecalculate',
                [
                    $membership->getMembershipId()
                ]
            );
        }
    }

    public function runQuickData(
        DeferrerCallbackRunEvent $callbackRunEvent,
        string $eventName,
        EventDispatcherInterface $dispatcher
    ): void {
        if ($dtos = $callbackRunEvent->getCallbackDto('quickDataMembershipRecalculate')) {
            foreach ($dtos as $dto) {
                if ($membershipId = $dto->getArgs()[0]) {
                    $membership = $this->entityManager
                        ->getRepository(Membership::class)
                        ->find($membershipId);

                    if ($membership) {
                        $this->quickData->updateMembershipData($membership);
                    }
                }
            }
        }
    }
}
