<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\EntityCallback;

use Doctrine\Persistence\Event\LifecycleEventArgs;
use XLite\Model\Country;
use XLite\Model\ZoneElement;

final class CountryCallback
{
    public function preRemove(Country $country, LifecycleEventArgs $args): void
    {
        $entityManager = $args->getObjectManager();
        $elements = $entityManager->getRepository(ZoneElement::class)->findBy(
            [
                'element_type'  => ZoneElement::ZONE_ELEMENT_COUNTRY,
                'element_value' => $country->getCode(),
            ]
        );

        foreach ($elements as $element) {
            $entityManager->remove($element);
        }
    }
}
