<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\EntityCallback;

use Doctrine\Persistence\Event\LifecycleEventArgs;
use XLite\Model\Base\Catalog;

final class CatalogCallback
{
    public function prePersist(Catalog $catalog, LifecycleEventArgs $args): void
    {
        $this->prepareBeforeSave($catalog);
    }

    public function preUpdate(Catalog $catalog, LifecycleEventArgs $args): void
    {
        $this->prepareBeforeSave($catalog);
    }

    private function prepareBeforeSave(Catalog $catalog): void
    {
        if (\XLite\Core\Converter::isEmptyString($catalog->getCleanURL())) {
            $catalog->setCleanURL($catalog->generateCleanURL());
        }
    }
}
