<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\EntityCallback;

use Doctrine\Persistence\Event\LifecycleEventArgs;
use XLite\Model\Cart;

final class CartCallback
{
    public function prePersist(Cart $cart, LifecycleEventArgs $args): void
    {
        $time = \XLite\Core\Converter::time();
        $cart->setDate($time);
        $cart->setLastRenewDate($time);
    }

    public function preUpdate(Cart $cart, LifecycleEventArgs $args): void
    {
        $time = \XLite\Core\Converter::time();
        $cart->setDate($time);
    }

    public function preRemove(Cart $cart, LifecycleEventArgs $args): void
    {
        $cart->prepareBeforeRemove();
    }
}
