<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\EntityCallback;

use Doctrine\ORM\EntityManagerInterface;
use XLite\Model\Attribute;
use XLite\Model\AttributeProperty;

final class AttributeCallback
{
    public function __construct(
        private EntityManagerInterface $entityManager
    ) {
    }

    public function postUpdate(Attribute $attribute): void
    {
        $this->entityManager->getRepository(AttributeProperty::class)?->updateFromAttribute($attribute);
    }
}
