<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\EntityCallback;

use Doctrine\Persistence\Event\LifecycleEventArgs;
use XLite\Model\AccessControlCell;

final class AccessControlCellCallback
{
    public function prePersist(AccessControlCell $accessControlCell, LifecycleEventArgs $args): void
    {
        if (!$accessControlCell->getDate()) {
            $accessControlCell->setDate(\XLite\Core\Converter::time());
        }
    }
}
