<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Doctrine\CallbackManager;

final class DeferredCallbackDto
{
    public function __construct(
        private string $deferredType,
        private array $args = []
    ) {
    }

    public function getDeferredType(): string
    {
        return $this->deferredType;
    }

    public function getArgs(): array
    {
        return $this->args;
    }
}
