<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Doctrine\CallbackManager;

final class DeferredCallbackBuffer implements \Iterator
{
    private array $deferredCallbacks = [];

    private int $position = 0;

    public function addDeferredCallback(string $deferredType, array $args): void
    {
        $this->deferredCallbacks[$deferredType][] = new DeferredCallbackDto($deferredType, $args);
    }

    public function getAll(): array
    {
        return $this->deferredCallbacks;
    }

    public function clear(): void
    {
        $this->deferredCallbacks = [];
        $this->position = 0;
    }

    public function current(): mixed
    {
        return $this->deferredCallbacks[$this->position];
    }

    public function next(): void
    {
        ++$this->position;
    }

    public function key(): int
    {
        return $this->position;
    }

    public function valid(): bool
    {
        return isset($this->deferredCallbacks[$this->position]);
    }

    public function rewind(): void
    {
        $this->position = 0;
    }
}
