<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Doctrine\CallbackManager;

final class CallbackManager
{
    public function __construct(
        private Context $context,
        private DeferredCallbackBuffer $buffer
    ) {
    }

    public function addDeferredCallback(string $deferredType, array $args): void
    {
        $this->buffer->addDeferredCallback($deferredType, $args);
    }

    public function shiftCallbacks(): array
    {
        $callbacks = $this->buffer->getAll();
        $this->buffer->clear();

        return $callbacks;
    }

    public function getCallbacks(): array
    {
        return $this->buffer->getAll();
    }

    public function setContextValue(string $contextValue): void
    {
        $this->context->setValue($contextValue);
    }

    public function getContextValue(): string
    {
        return $this->context->getValue();
    }

    public function contextIsEmpty(): bool
    {
        return $this->context->isEmpty();
    }
}
