<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\DependencyInjection\Compiler;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;
use XCart\ApiPlatform\Core\OpenApi\Factory\SwaggerUIOpenApiFactory;

class UpdateSwaggerUIPass implements CompilerPassInterface
{
    public function process(ContainerBuilder $container)
    {
        $definition = $container->getDefinition('api_platform.swagger_ui.action');
        $definition->setArgument(4, new Reference(SwaggerUIOpenApiFactory::class));
    }
}
