<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\DependencyInjection\Compiler;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;

class GeneratedServiceModificationPass implements CompilerPassInterface
{
    public function process(ContainerBuilder $container)
    {
        if ($container->hasDefinition('xcart.logic.storefront.category.get_one.action.arguments.assembler')) {
            $container
                ->getDefinition('xcart.logic.storefront.category.get_one.action.arguments.assembler')
                ->setArgument('$idFieldName', 'category_id');
        }

        if ($container->hasDefinition('xcart.logic.storefront.product.get_one.action.arguments.assembler')) {
            $container
                ->getDefinition('xcart.logic.storefront.product.get_one.action.arguments.assembler')
                ->setArgument('$idFieldName', 'product_id');
        }
    }
}
