<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\DependencyInjection\Compiler;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use XCart\Bundle\LogicBundle\DependencyInjection\LogicExtension;
use XCart\Logic\Decorator\RequestEnricher\Profile\ProfileOwnerEnrichDecorator;

final class AddProfileOwnerEnrichDecoratorPass implements CompilerPassInterface
{
    public function process(ContainerBuilder $container): void
    {
        foreach ($container->findTaggedServiceIds(LogicExtension::ACTION_TAG) as $id => $tag) {
            $decoratorId = $id . '.decorator.profile_owner_request';
            $container
                ->register($decoratorId, ProfileOwnerEnrichDecorator::class)
                ->setDecoratedService($id)
                ->setPublic(true)
                ->setAutowired(true);
        }
    }
}
