<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\DependencyInjection\Compiler;

use Symfony\Component\DependencyInjection\ContainerBuilder;
use XCart\API\Entity\Storefront\Product\Compact as ApiProductCompact;
use XCart\API\Entity\Storefront\Product\Detailed as ApiProductDetailed;
use XCart\Logic\Entity\Storefront\Product as LogicProduct;

trait AddFieldsForProductTrait
{
    private function addProductFields(
        ContainerBuilder $container,
        array $fields,
        bool $addFieldsToApiProductCompact = true
    ): void {
        $dtoGeneratorConfigName = 'xcart.dto_generator.config';

        if ($container->getParameter($dtoGeneratorConfigName)) {
            /** @var array[] $dtoGeneratorConfig */
            $dtoGeneratorConfig = $container->getParameter($dtoGeneratorConfigName);

            if ($addFieldsToApiProductCompact) {
                $dtoGeneratorConfig['entities']['api'][ApiProductCompact::class]['fields'] = array_merge(
                    $dtoGeneratorConfig['entities']['api'][ApiProductCompact::class]['fields'],
                    $fields
                );
            }

            $dtoGeneratorConfig['entities']['api'][ApiProductDetailed::class]['fields'] = array_merge(
                $dtoGeneratorConfig['entities']['api'][ApiProductDetailed::class]['fields'],
                $fields
            );

            $dtoGeneratorConfig['entities']['logic'][LogicProduct::class]['fields'] = array_merge(
                $dtoGeneratorConfig['entities']['logic'][LogicProduct::class]['fields'],
                $fields
            );

            $container->setParameter($dtoGeneratorConfigName, $dtoGeneratorConfig);
        }
    }
}
