<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\DataSource\Product\Applier;

use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value\StringValue;
use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value\FilterValueInterface;
use XCart\Bundle\DoctrineBridgeBundle\Enricher\GetList\Filter\Applier\ApplierInterface;
use XCart\Bundle\DoctrineBridgeBundle\QueryBuilder\QueryBuilderInterface;
use XCart\Operation\Service\DataSource\Product\Applier\SubstringApplier\GetLinkedTablesInterface;
use XCart\Operation\Service\DataSource\Product\Applier\SubstringApplier\GetSubstringSearchFieldsInterface;

class SubstringApplier implements ApplierInterface
{
    public function __construct(
        private GetLinkedTablesInterface $getLinkedTables,
        private GetSubstringSearchFieldsInterface $getSubstringSearchFields
    ) {
    }

    /**
     * @param StringValue $filterValue
     */
    public function apply(string $name, FilterValueInterface $filterValue, QueryBuilderInterface $queryBuilder): QueryBuilderInterface
    {
        foreach (($this->getLinkedTables)() as $linkedTable) {
            $queryBuilder->linkLeft($linkedTable['tableName'], $linkedTable['alias']);
        }

        $orCnd = new \Doctrine\ORM\Query\Expr\Orx();
        foreach (($this->getSubstringSearchFields)() as $field) {
            $orCnd->add($field . ' LIKE :substring');
        }

        return $queryBuilder->andWhere($orCnd)
            ->setParameter('substring', "%{$filterValue->getValue()}%");
    }
}
