<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\DataSource\Product\Applier;

use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value\BooleanValue;
use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value\FilterValueInterface;
use XCart\Bundle\DoctrineBridgeBundle\Enricher\GetList\Filter\Applier\ApplierInterface;
use XCart\Bundle\DoctrineBridgeBundle\QueryBuilder\QueryBuilderInterface;

class OutOfStockApplier implements ApplierInterface
{
    /**
     * @param BooleanValue $filterValue
     */
    public function apply(string $name, FilterValueInterface $filterValue, QueryBuilderInterface $queryBuilder): QueryBuilderInterface
    {
        if ($filterValue->getValue()) {
            $queryBuilder
                ->andWhere('entity.amount <= 0')
                ->andWhere('entity.inventoryEnabled = 1');
        } else {
            $outOfStockCondition = $queryBuilder->expr()->orX();

            $outOfStockCondition
                ->add('entity.amount > 0')
                ->add('entity.inventoryEnabled = 0');

            $queryBuilder->andWhere($outOfStockCondition);
        }

        return $queryBuilder;
    }
}
