<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\DataSource\Payment;

use XCart\Bundle\DoctrineBridgeBundle\Collection\EntityCollectionInterface;
use XCart\Bundle\DoctrineBridgeBundle\DataSource\DTO\CountListCriteria;
use XCart\Bundle\DoctrineBridgeBundle\DataSource\DTO\FindListCriteria;
use XCart\Bundle\DoctrineBridgeBundle\DataSource\ReadDataSourceInterface;
use XCart\Bundle\DoctrineBridgeBundle\Entity\EntityInterface;
use XCart\Bundle\DoctrineBridgeBundle\Repository\ReadRepositoryInterface;

/**
 * @todo: Temporary class, we need to define and use fineOneBy method (ECOM-3177)
 */
class TransactionRead implements ReadDataSourceInterface
{
    public function __construct(
        private ReadDataSourceInterface $inner,
        private ReadRepositoryInterface $repository,
    ) {
    }

    public function count(): int
    {
        return $this->inner->count();
    }

    public function hasOne(int|string $id): bool
    {
        return $this->inner->hasOne($id);
    }

    public function findOne(int|string $id): ?EntityInterface
    {
        return $this->repository->findOneBy(['publicTxnId' => $id]);
    }

    public function findList(FindListCriteria $criteria): EntityCollectionInterface
    {
        return $this->inner->findList($criteria);
    }

    public function countList(CountListCriteria $criteria): int
    {
        return $this->inner->countList($criteria);
    }

    public function hasList(CountListCriteria $criteria): bool
    {
        return $this->inner->hasList($criteria);
    }
}
