<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\DataSource\Common\Applier;

use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value\FilterValueInterface;
use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value\IntegerListValue;
use XCart\Bundle\DoctrineBridgeBundle\Enricher\GetList\Filter\Applier\ApplierInterface;
use XCart\Bundle\DoctrineBridgeBundle\QueryBuilder\QueryBuilderInterface;

class MembershipApplier implements ApplierInterface
{
    /**
     * @param IntegerListValue $filterValue
     */
    public function apply(string $name, FilterValueInterface $filterValue, QueryBuilderInterface $queryBuilder): QueryBuilderInterface
    {
        $membershipId = $filterValue->getValue();

        $queryBuilder->linkLeft('entity.memberships', 'membership');

        if ($membershipId) {
            $queryBuilder->andWhere('membership.membership_id = :membershipId OR membership.membership_id IS NULL')
                ->setParameter('membershipId', $membershipId);
        } else {
            $queryBuilder->andWhere('membership.membership_id IS NULL');
        }

        return $queryBuilder;
    }
}
