<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Controller;

use Symfony\Component\HttpFoundation\Response;

class XCartController
{
    /**
     * Is customer action
     */
    public function index(): Response
    {
        return $this->run();
    }

    public function admin(): Response
    {
        return $this->run();
    }

    private function run(): Response
    {
        $xc = \XLite::getInstance();
        $xc->processRequest();

        $response = new Response($xc->getContent(), $xc->getStatusCode(), $xc->getHeaders());

        foreach ($xc->getCookiesForHeaders() as $cookie) {
            $response->headers->setCookie($cookie);
        }

        return $response;
    }
}
