<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\API;

use ApiPlatform\Core\OpenApi\Factory\OpenApiFactoryInterface;
use ApiPlatform\Core\OpenApi\OpenApi;
use ApiPlatform\OpenApi\Model\PathItem;

class OpenApiFactoryTagGroupsNormalizationDecorator implements OpenApiFactoryInterface
{
    public function __construct(
        private OpenApiFactoryInterface $inner,
    ) {
    }

    public function __invoke(array $context = []): OpenApi
    {
        $api = $this->inner->__invoke($context);

        $usedTagGroups = $this->getUsedTagGroups($api);
        $groups = $api->getExtensionProperties()['x-tagGroups'];
        foreach ($groups as $k => $group) {
            $group['tags'] = array_intersect($group['tags'], $usedTagGroups);
            if (empty($group['tags'])) {
                unset($groups[$k]);
                continue;
            }

            $group['tags'] = array_values($group['tags']);
            $groups[$k] = $group;
        }

        return $api->withExtensionProperty('x-tagGroups', $groups);
    }

    /**
     * @return string[]
     */
    private function getUsedTagGroups(OpenApi $api): array
    {
        $usedTagGroups = [];

        /** @var PathItem $pathItem */
        foreach ($api->getPaths()->getPaths() as $pathItem) {
            if ($pathItem->getGet()) {
                $usedTagGroups[] = $pathItem->getGet()->getTags();
            }
            if ($pathItem->getPost()) {
                $usedTagGroups[] = $pathItem->getPost()->getTags();
            }
            if ($pathItem->getPut()) {
                $usedTagGroups[] = $pathItem->getPut()->getTags();
            }
            if ($pathItem->getPatch()) {
                $usedTagGroups[] = $pathItem->getPatch()->getTags();
            }
            if ($pathItem->getDelete()) {
                $usedTagGroups[] = $pathItem->getDelete()->getTags();
            }
        }

        return array_unique(array_merge(...$usedTagGroups));
    }
}
