<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\API;

use ApiPlatform\Core\OpenApi\Factory\OpenApiFactoryInterface;
use ApiPlatform\Core\OpenApi\OpenApi;

class OpenApiFactoryRemoveFieldsDecorator implements OpenApiFactoryInterface
{
    public function __construct(
        private OpenApiFactoryInterface $inner,
    ) {
    }

    public function __invoke(array $context = []): OpenApi
    {
        /** @var OpenApi $api */
        $api = $this->inner->__invoke($context);

        $schemas = $api->getComponents()->getSchemas();
        if (!$schemas) {
            return $api;
        }

        // Change /api/storefront/carts/{cart_id}/items
        $properties = $schemas->offsetGet('AttributeValue-insert')->offsetGet('properties');
        unset($properties['name']);
        $schemas->offsetGet('AttributeValue-insert')->offsetSet('properties', $properties);

        $properties = $schemas->offsetGet('AttributeValue-update')->offsetGet('properties');
        unset($properties['name']);
        $schemas->offsetGet('AttributeValue-update')->offsetSet('properties', $properties);

        return $api;
    }
}
