<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\API;

use ApiPlatform\Core\OpenApi\Factory\OpenApiFactoryInterface;
use ApiPlatform\Core\OpenApi\OpenApi;
use ApiPlatform\OpenApi\Model\Parameter;
use ApiPlatform\OpenApi\Model\PathItem;
use XCart\Operation\Service\API\GetPathsWithCartIdInterface;

class OpenApiFactoryAddParametersDecorator implements OpenApiFactoryInterface
{
    public function __construct(
        private OpenApiFactoryInterface $inner,
        private GetPathsWithCartIdInterface $getPathsWithCartId,
    ) {
    }

    public function __invoke(array $context = []): OpenApi
    {
        /** @var OpenApi $api */
        $api = $this->inner->__invoke($context);

        // Cart items
        $cartId = new Parameter(
            'cart_id',
            'path',
            'Cart ID',
            true,
            false,
            false,
            [
                'type'      => 'string',
                'format'    => 'uuid4',
                'minLength' => 36,
                'maxLength' => 36,
                'pattern'   => '^[0-9a-f]{12}4[0-9a-f]{3}[89ab][0-9a-f]{15}$',
            ]
        );

        /** @var PathItem $pathItem */
        foreach ($api->getPaths()->getPaths() as $path => $pathItem) {
            if (in_array($path, ($this->getPathsWithCartId)(), true)) {
                if ($pathItem->getGet()) {
                    $parameters = $pathItem->getGet()->getParameters();
                    $parameters[] = $cartId;
                    $pathItem = $pathItem->withGet($pathItem->getGet()->withParameters($parameters));
                }

                if ($pathItem->getPost()) {
                    $parameters = $pathItem->getPost()->getParameters();
                    $parameters[] = $cartId;
                    $pathItem = $pathItem->withPost($pathItem->getPost()->withParameters($parameters));
                }

                if ($pathItem->getPut()) {
                    $parameters = $pathItem->getPut()->getParameters();
                    $parameters[] = $cartId;
                    $pathItem = $pathItem->withPut($pathItem->getPut()->withParameters($parameters));
                }

                if ($pathItem->getPatch()) {
                    $parameters = $pathItem->getPatch()->getParameters();
                    $parameters[] = $cartId;
                    $pathItem = $pathItem->withPatch($pathItem->getPatch()->withParameters($parameters));
                }

                if ($pathItem->getDelete()) {
                    $parameters = $pathItem->getDelete()->getParameters();
                    $parameters[] = $cartId;
                    $pathItem = $pathItem->withDelete($pathItem->getDelete()->withParameters($parameters));
                }

                $api->getPaths()->addPath($path, $pathItem);
            }
        }

        return $api;
    }
}
