<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\API\EventSubscriber\Storefront;

use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpKernel\Event\RequestEvent;
use Symfony\Component\HttpKernel\KernelEvents;
use Symfony\Component\Security\Core\Security;
use XLite\Model\Profile as ProfileModel;
use XLite\Model\Repo\Profile;

class ProfileDetectionEventSubscriber implements EventSubscriberInterface
{
    public function __construct(
        private Security $security,
        private Profile $profileRepository,
    ) {
    }

    public static function getSubscribedEvents(): array
    {
        return [
            KernelEvents::REQUEST => [
                ['process', 7],
            ],
        ];
    }

    public function process(RequestEvent $event): void
    {
        if (!$event->isMainRequest() || $event->getRequest()->getMethod() === 'OPTIONS') {
            return;
        }

        if (!preg_match('/api\/storefront\//S', $event->getRequest()->getPathInfo())) {
            return;
        }

        $user = $this->security->getUser();
        if (!$user || !$user->getUserIdentifier()) {
            return;
        }

        /** @var ProfileModel $profile */
        $profile = $this->profileRepository->findOneBy(['login' => $user->getUserIdentifier()]);
        if (!$profile) {
            return;
        }

        $event->getRequest()->attributes->set('_profile_id', $profile->getProfileId());
        $event->getRequest()->attributes->set('_profile', $profile);
    }
}
