<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\API\EventSubscriber;

use Symfony\Component\HttpKernel\Event\ExceptionEvent;

class ExceptionListenerDecorator
{
    private const DEFAULT_PATTERN = '/^\/api\//Ss';

    /**
     * @param \ApiPlatform\Symfony\EventListener\ExceptionListener $inner
     */
    public function __construct(
        private object $inner,
        private string $pattern = self::DEFAULT_PATTERN
    ) {
    }

    public function onKernelException(ExceptionEvent $event): void
    {
        if (preg_match($this->pattern, $event->getRequest()->getPathInfo())) {
            $event->getRequest()->attributes->set('_api_respond', true);
        }

        $this->inner->onKernelException($event);
    }
}
