<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\API\Endpoint\Storefront\ResetPasswordAction\ResetPassword\DataPersister\Persister;

use ApiPlatform\Exception\RuntimeException;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Exception\BadRequestHttpException;
use XCart\Bundle\APIPlatformBridgeBundle\API\DataPersister\Persister\PersisterInterface;
use XCart\Bundle\APIPlatformBridgeBundle\API\DataPersister\Persister\Assembler\RequestAssemblerInterface;
use XCart\Bundle\APIPlatformBridgeBundle\API\Entity\EntityInterface;
use XCart\Bundle\CommonBundle\DTO\Id\IdOwnerInterface;
use XCart\Bundle\LogicBundle\Action\ActionInterface;
use XCart\Bundle\LogicBundle\DTO\Response\DefaultFailedResponse;
use XCart\Bundle\LogicBundle\DTO\Response\PayloadOwnerResponseInterface;

class Persister implements PersisterInterface
{
    public function __construct(
        private ActionInterface $resetPasswordAction,
        private RequestAssemblerInterface $resetPasswordRequestAssembler,
    ) {
    }

    public function persist(IdOwnerInterface $data, array $context): EntityInterface
    {
        /** @var PayloadOwnerResponseInterface $response */
        $request  = $this->resetPasswordRequestAssembler->assemble($data, $context);
        $response = $this->resetPasswordAction->run($request);

        if ($response instanceof DefaultFailedResponse) {
            throw match ($response->getStatus()) {
                Response::HTTP_BAD_REQUEST => new BadRequestHttpException($response->getTitle()),
                default => new RuntimeException($response->getTitle()),
            };
        }

        return $data;
    }
}
