<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\API\Endpoint\Storefront\ResetPasswordAction\ResetPassword\DataPersister;

use ApiPlatform\Core\DataPersister\ContextAwareDataPersisterInterface;
use XCart\Bundle\APIPlatformBridgeBundle\API\DataPersister\Persister\PersisterInterface;
use Symfony\Component\HttpFoundation\Response;

/**
 * @property string[] $classes
 */
class DataPersister implements ContextAwareDataPersisterInterface
{
    public function __construct(
        private array $classes,
        private PersisterInterface $persister,
    ) {
    }

    public function supports($data, array $context = []): bool
    {
        return in_array(get_class($data), $this->classes, true);
    }

    public function persist($data, array $context = []): object
    {
        $this->persister->persist($data, $context);

        return new Response('OK', 204);
    }

    public function remove($data, array $context = [])
    {
    }
}
