<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\API\Endpoint\Storefront\Product\Detailed\GetOneByCleanURL\SubIdentifierExtractor;

use XCart\API\Entity\Storefront\Product\Detailed as APIEntity;
use XCart\Framework\ApiPlatform\Core\Api\SubIdentifierExtractor\SubIdentifierExtractorInterface;

class SubIdentifierExtractor implements SubIdentifierExtractorInterface
{
    public function getIdentifiersFromResourceClass(string $resourceClass): array
    {
        return ['id'];
    }

    public function getIdentifiersFromItem($item): array
    {
        /** @var APIEntity $item */
        return [
            'id' => $item->getId(),
        ];
    }

    public function supportResourceClass(string $resourceClass): bool
    {
        return $resourceClass === APIEntity::class;
    }

    public function supportItem(object $item): bool
    {
        return $this->supportResourceClass(get_class($item));
    }
}
