<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\API\Endpoint\Storefront\PaymentMethodSelection\DataPersister\Persister\Assembler;

use XCart\API\Entity\Storefront\Cart\PaymentMethodSelection;
use XCart\Bundle\APIPlatformBridgeBundle\API\DataPersister\Persister\Assembler\ResponseAssemblerInterface;
use XCart\Bundle\APIPlatformBridgeBundle\API\Entity\EntityInterface;
use XCart\Bundle\LogicBundle\DTO\Response\PayloadOwnerResponseInterface;
use XCart\Logic\Action\Storefront\Cart\PaymentMethodSelection\CreateOne\DTO\Response as ResponseLogic;
use XLite\Model\Cart as CartModel;
use Xlite\Model\Repo\Cart as CartReadRepository;

class ResponseAssemblerDecorator implements ResponseAssemblerInterface
{
    public function __construct(
        private ResponseAssemblerInterface $inner,
        private CartReadRepository $cartReadRepository
    ) {
    }

    /**
     * @param ResponseLogic $response
     *
     * @return PaymentMethodSelection
     */
    public function assemble(PayloadOwnerResponseInterface $response): EntityInterface
    {
        /** @var PaymentMethodSelection $entity */
        $entity = $this->inner->assemble($response);

        /** @var CartModel $cart */
        $cart = $this->cartReadRepository->find($response->getPayload()->getCartId());
        $entity->setId($cart->getPublic_id());

        return $entity;
    }
}
